<?php
namespace DogriElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Dogri Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */

 
 
class Choose_Widget extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'choose_widget';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Choose Widget', 'dogri-elementor' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-favorite';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'dogri-elementor' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		// Tab Start - 1

		$this->start_controls_section(
			'choose_widget',
			[
				'label' => esc_html__( 'Choose Widget', 'dogri-elementor' ),
			]
		);		

		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'dogri-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your title', 'dogri-elementor' ),
			]
		);		


	$this->add_control(
			'subtitle',
			[
				'label'       => __( 'Sub Title', 'dogri-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your sub title', 'dogri-elementor' ),
			]
		);

		
	$this->add_control(
		'bgimg',
		[
			'label' => esc_html__('Background image', 'dogri-elementor'),
			'type' => Controls_Manager::MEDIA,
			'default' => ['url' => Utils::get_placeholder_image_src(),],
		]
	);
		
		$this->end_controls_section();

		
		
		// Tab Start - 2

		$this->start_controls_section(
					'content_section',
					[
						'label' => __( 'Block', 'dogri-elementor' ),
						'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
					]
				);
				$this->add_control(
				  'repeat', 
					[
						'type' => Controls_Manager::REPEATER,
						'seperator' => 'before',
						'default' => 
							[
								['block_title' => esc_html__('Projects Completed', 'dogri-elementor')],
							],
						'fields' => 
							[
								
								'block_icons' =>
								[
									'name' => 'block_icons',
									'label' => esc_html__('Enter The icons', 'dogri-elementor'),
									'type' => Controls_Manager::ICONS,							
								],

								'block_title' =>
								[
									'name' => 'block_title',
									'label' => esc_html__('Title', 'dogri-elementor'),
									'type' => Controls_Manager::TEXTAREA,
									'default' => esc_html__('', 'dogri-elementor')
								],
								
								'block_subtitle' =>
								[
									'name' => 'block_subtitle',
									'label' => esc_html__('Sub Title', 'dogri-elementor'),
									'type' => Controls_Manager::TEXTAREA,
									'default' => esc_html__('', 'dogri-elementor')
								],

								'block_btnlink' =>
								[
									'name' => 'block_btnlink',
									'label' => __( 'Button Url', 'dogri-elementor' ),
									'type' => Controls_Manager::URL,
									'placeholder' => __( 'https://your-link.com', 'dogri-elementor' ),
									'show_external' => true,
									'default' => [
									'url' => '',
									'is_external' => true,
									'nof
									ollow' => true,
									],
								],
							],
						'title_field' => '{{block_title}}',
					 ]
			);
				
				
		$this->end_controls_section();	

	
		}

	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');
		?>

<?php
	  echo '
	 <script>
 jQuery(document).ready(function($) {

//put the js code under this line 


//put the code above the line 

  });
</script>';


?>

<!-- choose-section -->
<section class="choose-section sec-padding" style="background-image: url(<?php echo wp_get_attachment_url($settings['bgimg']['id']);?>);">
    <div class="dogri-container">
		<?php if($settings['title']): ?>
        <div class="title-box text-center" data-aos="zoom-in" data-aos-duration="500">
            <h4 class="sec-sub-title"><?php echo $settings['subtitle'];?> </h4>
            <h2 class="sec-title"><?php echo $settings['title'];?></h2>                  
        </div>
		<?php endif; ?>
        <div class="row g-2" data-aos="zoom-in" data-aos-duration="1000">
            <!-- block -->
			<?php foreach($settings['repeat'] as $item):?>
            <div class="col-lg-3 col-md-6">
                <div class="choose-box">
                    <div class="icon">
                        <i class="<?php echo str_replace("icon ", " ", esc_attr( $item['block_icons']['value']));?>"></i>
                    </div>
                    <div class="content">
                        <h4><a href="<?php echo esc_url($item['block_btnlink']['url']);?>"><?php echo wp_kses($item['block_title'], $allowed_tags);?></a></h4>
                        <p><?php echo wp_kses($item['block_subtitle'], $allowed_tags);?></p>
                    </div>
                </div>
            </div>
			<?php endforeach; ?>
        </div>
    </div>
</section>
<!-- choose-section-end -->
             




		<?php 
	}


}
